using System;
using System.Data;
using System.Text;
using System.IO;
using System.Xml;
using gov.va.med.vbecs.Common;

namespace gov.va.med.vbecs.DAL
{
	#region Header

	///<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
	///<Warning> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</Warning>
	///<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
	///<Developers>
	///	<Developer>Cameron Taylor</Developer>
	///</Developers>
	///<SiteName>Hines OIFO</SiteName>
	///<CreationDate>06/21/2005</CreationDate>
	///<Note>The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</Note>
	///<summary>
	/// VbecsReport data access layer class.
	///</summary>

	#endregion
	
	public class VbecsReport
	{

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>6/22/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="7330"> 
		///		<ExpectedInput>Valid Parameters</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///
		///<Case type="1" testid ="7331"> 
		///		<ExpectedInput>Invalid Parameters</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Get all scheduled reports in a specified task status
		/// </summary>
		/// <param name="status">Task Status code</param>
		/// <returns>Scheduled Report data table</returns>
		public static DataTable GetScheduledReports(Common.TaskStatus status)
		{
			System.Data.SqlClient.SqlParameter[] prms =
			{
				new System.Data.SqlClient.SqlParameter(Common.VbecsStoredProcs.GetScheduledReports.reportprintdate,System.Data.SqlDbType.DateTime),
				new System.Data.SqlClient.SqlParameter(Common.VbecsStoredProcs.GetScheduledReports.taskstatuscode,System.Data.SqlDbType.Char)
			};
			prms[0].Value = DateTime.Now;
			prms[1].Value = Common.Utility.GetTaskStatusCodeFromEnum(status);
			//
			return Common.StoredProcedure.GetDataTable(Common.VbecsStoredProcs.GetScheduledReports.StoredProcName, prms);
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>6/22/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="7332"> 
		///		<ExpectedInput>Valid Parameters</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///
		///<Case type="1" testid ="7333"> 
		///		<ExpectedInput>Invalid Parameters</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Get a scheduled report record
		/// </summary>
		/// <param name="scheduledReportGuid">Scheduled Report Guid</param>
		/// <returns>Scheduled Report data table</returns>
		public static DataTable GetScheduledReport(Guid scheduledReportGuid)
		{
			System.Data.SqlClient.SqlParameter[] prms =
			{
				new System.Data.SqlClient.SqlParameter(Common.VbecsStoredProcs.GetScheduledReportByGuid.scheduledreportguid,System.Data.SqlDbType.UniqueIdentifier)
			};
			prms[0].Value = scheduledReportGuid;
			//
			return Common.StoredProcedure.GetDataTable(Common.VbecsStoredProcs.GetScheduledReportByGuid.StoredProcName, prms);
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>6/22/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="7334"> 
		///		<ExpectedInput>Valid Parameters</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///
		///<Case type="1" testid ="7335"> 
		///		<ExpectedInput>Invalid Parameters</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Update the task status of a scheduled report record
		/// </summary>
		/// <param name="scheduledReportGuid">Scheduled Report Guid</param>
		/// <param name="status">Task Status code</param>
		/// <param name="rowVersion">Row Version</param>
		/// <returns>Success indicator</returns>
		public static bool UpdateScheduledReportStatus(Guid scheduledReportGuid, Common.TaskStatus status, byte[] rowVersion)
		{
			System.Data.SqlClient.SqlParameter[] prms =
			{
				new System.Data.SqlClient.SqlParameter(Common.VbecsStoredProcs.UpdateScheduledReportStatus.scheduledreportguid, System.Data.SqlDbType.UniqueIdentifier),
				new System.Data.SqlClient.SqlParameter(Common.VbecsStoredProcs.UpdateScheduledReportStatus.taskstatuscode, System.Data.SqlDbType.Char),
				new System.Data.SqlClient.SqlParameter(Common.VbecsStoredProcs.UpdateScheduledReportStatus.lastupdateuser, System.Data.SqlDbType.VarChar),
				new System.Data.SqlClient.SqlParameter(Common.VbecsStoredProcs.UpdateScheduledReportStatus.lastupdatefunctionid, System.Data.SqlDbType.Int),
				new System.Data.SqlClient.SqlParameter(Common.VbecsStoredProcs.UpdateScheduledReportStatus.rowversion, System.Data.SqlDbType.Timestamp)
			};
			prms[0].Value = scheduledReportGuid;
			prms[1].Value = Common.Utility.GetTaskStatusCodeFromEnum(status);
			prms[2].Value = Common.LogonUser.LogonUserName;
			prms[3].Value = (int)Common.UpdateFunction.VbecsScheduledReportRunner;
			prms[4].Value = rowVersion;
			//
			return (new StoredProcedure().TransactionalGetValue(Common.VbecsStoredProcs.UpdateScheduledReportStatus.StoredProcName,prms) == 0);
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>6/22/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="7336"> 
		///		<ExpectedInput>Valid Parameters</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///
		///<Case type="1" testid ="7337"> 
		///		<ExpectedInput>Invalid Parameters</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Create a scheduled report record
		/// </summary>
		/// <param name="reportParameters">Report parameters as a data set</param>
		/// <param name="reportPrintDate">Report print date</param>
		/// <returns>Success indicator</returns>
		public static bool InsertScheduledReport(DataSet reportParameters, DateTime reportPrintDate)
		{
			System.Data.SqlClient.SqlParameter[] prms =
			{
				new System.Data.SqlClient.SqlParameter(Common.VbecsStoredProcs.InsertScheduledReport.scheduledreportguid, System.Data.SqlDbType.UniqueIdentifier),
				new System.Data.SqlClient.SqlParameter(Common.VbecsStoredProcs.InsertScheduledReport.reportparameters, System.Data.SqlDbType.NText),
				new System.Data.SqlClient.SqlParameter(Common.VbecsStoredProcs.InsertScheduledReport.reportprintdate, System.Data.SqlDbType.DateTime),
				new System.Data.SqlClient.SqlParameter(Common.VbecsStoredProcs.InsertScheduledReport.taskstatuscode, System.Data.SqlDbType.Char),
				new System.Data.SqlClient.SqlParameter(Common.VbecsStoredProcs.InsertScheduledReport.lastupdateuser, System.Data.SqlDbType.VarChar),
				new System.Data.SqlClient.SqlParameter(Common.VbecsStoredProcs.InsertScheduledReport.lastupdatefunctionid, System.Data.SqlDbType.Int)
			};
			prms[0].Value = Guid.NewGuid();
			prms[1].Value = ConvertDataSetToXml(reportParameters);
			prms[2].Value = reportPrintDate;
			prms[3].Value = Common.Utility.GetTaskStatusCodeFromEnum(Common.TaskStatus.NotStarted);
			prms[4].Value = Common.LogonUser.LogonUserName;
			prms[5].Value = (int)Common.UpdateFunction.VbecsScheduledReportRunner;
			//
			return (new StoredProcedure().TransactionalGetValue(Common.VbecsStoredProcs.InsertScheduledReport.StoredProcName,prms) == 0);
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>6/22/2005</CreationDate>
		///
		/// <summary>
		/// Convert a data set into an XML schema string
		/// </summary>
		/// <param name="ds">Data set</param>
		/// <returns>XML string</returns>
		private static string ConvertDataSetToXml(DataSet ds)  
		{
			MemoryStream stream = new MemoryStream();
			XmlTextWriter writer = new XmlTextWriter(stream, Encoding.ASCII);
			try
			{
				ds.WriteXml(writer, XmlWriteMode.WriteSchema);
				int count = (int) stream.Length;
				byte[] arr = new byte[count];
				stream.Seek(0, SeekOrigin.Begin);
				stream.Read(arr, 0, count);
				return new System.Text.ASCIIEncoding().GetString(arr).Trim();
			}
			finally
			{
				writer.Close();
			}
		}
	}
}
